// file: TomCat.cpp

#include <stdio.h>
//#include "nios.h" 

#include "tc_vars.h"
#include "hardware_t.h"
#include "flash_t.h"
#include "display_t.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"

int main(void)										// Main program
{
	printf("\r\n\r\n*****************************\r\n");
	printf("Blue Flash firmware starting!\r\n");	
	printf("*****************************\r\n\r\n");

	printf("- Hardware initialization\r\n");
	Hardware::Init();
	printf("- Hardware initialization               - done\r\n");
	
	printf("- Display initialization\r\n");
	Display::Init();
	printf("- Display initialization                - done\r\n");
	
	Hardware::Restore_From_Flash();

	printf("- Starting up\r\n");
	Hardware::Start_Up();
	printf("- Starting up                           - done\r\n");
	
	printf("Ready - press h for help\r\n");

	// main loop
	while (0 == 0)
	{
		UserIF::Rotary_Interface();
		UserIF::Keyboard_Interface();
		Hardware::Handle_ADC();
		Signal::ProcessSignalData();
		Display::DrawSignals(1);		
		Hardware::TransferPlanes();
		CommIF::Transfer_USB_Data();
		AMDFlash::Write_Config_Flash();
	}
	
	//return 0;									// Exit
}



